#define BLYNK_TEMPLATE_ID "TMPL6rfCLTMII"
#define BLYNK_TEMPLATE_NAME "Konsumsi Daya Motor IPAL"
#define BLYNK_AUTH_TOKEN "dq6JEIiSBWpXHDrNpHgOyDuYfkC_j4xO"

#include <WiFi.h>
#include <BlynkSimpleEsp32.h>
#include <PZEM004Tv30.h>
#include <HTTPClient.h>

// WiFi credentials
const char* ssid = "Nramar";              // Ganti dengan SSID WiFi Anda
const char* password = "28081999";      // Ganti dengan password WiFi Anda

// Blynk credentials
char auth[] = "dq6JEIiSBWpXHDrNpHgOyDuYfkC_j4xO";      // Ganti dengan Auth Token Blynk Anda

// Google Apps Script URL
const char* serverName = "https://script.google.com/macros/s/AKfycbxMIhcKqY4-s3_AorYMVlfl9dibYpWQrmjPv0IMGflNs6dIUeDbcb1YIj3dATxH4NlFOQ/exec";  // Ganti dengan URL Google Apps Script Anda

// PZEM-004T pins
PZEM004Tv30 pzem(&Serial2, 16, 17); // TX=16, RX=17

// Relay pin
const int relayPin = 5;  // Pin GPIO untuk relay
bool motorStatus = false;  // Status motor (false = off, true = on)

// Blynk virtual pin
#define V0 0 // Blynk Virtual Pin untuk kontrol motor

BlynkTimer timer;

void sendDataToGoogleSheets() {
  if (WiFi.status() == WL_CONNECTED) {
    HTTPClient http;

    // Baca nilai tegangan, arus, dan daya dari PZEM-004T
    float voltage = pzem.voltage();
    float current = pzem.current();
    float power = pzem.power();

    // Cek validitas data sensor
    if (isnan(voltage) || isnan(current) || isnan(power)) {
      Serial.println("Failed to read sensor values!");
      return;
    }

    // Kirim data ke Google Sheets
    String motorStatusStr = motorStatus ? "ON" : "OFF";
    String serverPath = String(serverName) + "?voltage=" + String(voltage) +
                       "&current=" + String(current) +
                       "&power=" + String(power) +
                       "&motorStatus=" + motorStatusStr;

    http.begin(serverPath.c_str());
    int httpResponseCode = http.GET();
    
    // Cek respons HTTP
    if (httpResponseCode > 0) {
      String response = http.getString();
      Serial.println(httpResponseCode);
      Serial.println(response);
    } else {
      Serial.print("Error on sending GET: ");
      Serial.println(httpResponseCode);
    }

    http.end(); // Tutup koneksi
  }
}

void setup() {
  Serial.begin(115200);
  WiFi.begin(ssid, password);

  // Initialize PZEM-004T
  Serial2.begin(9600, SERIAL_8N1, 16, 17); // RX = 16, TX = 17

  // Setup relay pin
  pinMode(relayPin, OUTPUT);
  digitalWrite(relayPin, LOW);  // Pastikan motor dalam kondisi mati pada awalnya

  // Tunggu hingga ESP32 terhubung ke Wi-Fi
  while (WiFi.status() != WL_CONNECTED) {
    delay(1000);
    Serial.println("Connecting to WiFi...");
  }
  Serial.println("Connected to WiFi");

  // Inisialisasi Blynk
  Blynk.begin(auth, ssid, password);

  // Atur pengiriman data ke Google Sheets setiap 60 detik
  timer.setInterval(60000L, sendDataToGoogleSheets);
}

// Fungsi untuk kontrol motor melalui Blynk
BLYNK_WRITE(V0) {
  int pinValue = param.asInt(); // Ambil nilai dari Blynk button
  if (pinValue == 1) {
    digitalWrite(relayPin, HIGH);  // Nyalakan relay (motor ON)
    motorStatus = true;
    Serial.println("Motor ON");
  } else {
    digitalWrite(relayPin, LOW);  // Matikan relay (motor OFF)
    motorStatus = false;
    Serial.println("Motor OFF");
  }
}

void loop() {
  Blynk.run();
  timer.run();  // Timer untuk mengirim data ke Google Sheets
}
